    var map, posiciones = new Array();

    $(function(){

      function addRoute(origin, target) {
        map.drawRoute({
            origin: [origin.lat, origin.lng],  // origen en coordenadas anteriores
            // destino en coordenadas del click o toque actual
            destination: [target.lat, target.lng],
            travelMode: 'driving',
            strokeColor: '#000000',
            strokeOpacity: 0.6,
            strokeWeight: 5
          });
      }

      function enlazarMarcador(e){
        var targetPoint = {lat : e.latLng.lat(), lng: e.latLng.lng()};
        // muestra ruta entre marcas anteriores y actuales
        if (posiciones.length > 0) {
          addRoute(posiciones[posiciones.length-1], targetPoint);
        }
        posiciones.push(targetPoint);   // guarda coords para marca siguiente
        map.addMarker({lat : e.latLng.lat(), lng: e.latLng.lng()});  // pone marcador en mapa
      };

      function geolocalizar(){
        GMaps.geolocate({
          success: function(position){
            var currentPosition = { lat: position.coords.latitude, lng: position.coords.longitude};
            initMap(currentPosition);
            posiciones.push(currentPosition);  // guarda coords en lat y lng
            map.addMarker({ lat: position.coords.latitude, lng: position.coords.longitude});  // marcador en [lat, lng] 
          },
          error: function(error) { alert('Geolocalización falla: '+error.message); },
          not_supported: function(){ alert("Su navegador no soporta geolocalización"); },
        });
      };
      
      function initMap(position) {
        map = new GMaps({  // muestra mapa centrado en coords [lat, lng]
              el: '#map',
              lat: position.lat,
              lng: position.lng,
              click: enlazarMarcador,
              tap: enlazarMarcador
            }); 
      }

      function addPositions() {        
        for (var i = 0; i < posiciones.length; i++) {
          map.addMarker({lat : posiciones[i].lat, lng: posiciones[i].lng});
          if (i > 0) {
            addRoute(posiciones[i-1], posiciones[i]);
          }
        }
      }

      $('#compact').click(function() {
          if(posiciones != undefined && posiciones.length > 2) {
            var firstPosition = posiciones[0];
            var lastPosition = posiciones[posiciones.length-1];
            posiciones = new Array();
            posiciones.push(firstPosition);
            posiciones.push(lastPosition);
            map.removeMarkers();
            map.cleanRoute();
            addPositions();
          }
      });

      geolocalizar();
    });